/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.chunk.PackedIntArrayReader;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AnvilChunk18
implements Chunk {
    private final CompoundTag rootTag;
    private final Int2ObjectOpenHashMap<BlockState[]> blocks;
    private final int rootX;
    private final int rootZ;
    private Map<BlockVector3, Map<String, Tag>> tileEntities;

    public AnvilChunk18(CompoundTag tag) throws DataException {
        this.rootTag = tag;
        this.rootX = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "xPos", IntTag.class).getValue();
        this.rootZ = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "zPos", IntTag.class).getValue();
        Object sections = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "sections", ListTag.class).getValue();
        this.blocks = new Int2ObjectOpenHashMap(sections.size());
        Iterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            CompoundTag blockStatesTag;
            List<CompoundTag> paletteEntries;
            int paletteSize;
            Tag rawSectionTag = (Tag)iterator.next();
            if (!(rawSectionTag instanceof CompoundTag)) continue;
            CompoundTag sectionTag = (CompoundTag)rawSectionTag;
            Object yValue = ((Tag)sectionTag.getValue().get("Y")).getValue();
            if (!(yValue instanceof Number)) {
                throw new InvalidFormatException("Y is not numeric: " + yValue);
            }
            int y = ((Number)yValue).intValue();
            Tag rawBlockStatesTag = (Tag)sectionTag.getValue().get("block_states");
            if (!(rawBlockStatesTag instanceof CompoundTag) || (paletteSize = (paletteEntries = (blockStatesTag = (CompoundTag)rawBlockStatesTag).getList("palette", CompoundTag.class)).size()) == 0) continue;
            BlockState[] palette = new BlockState[paletteSize];
            for (int paletteEntryId = 0; paletteEntryId < paletteSize; ++paletteEntryId) {
                CompoundTag paletteEntry = paletteEntries.get(paletteEntryId);
                BlockType type = BlockTypes.get(paletteEntry.getString("Name"));
                if (type == null) {
                    throw new InvalidFormatException("Invalid block type: " + paletteEntry.getString("Name"));
                }
                BlockState blockState = type.getDefaultState();
                if (paletteEntry.containsKey("Properties")) {
                    CompoundTag properties = NBTUtils.getChildTag((Map<String, Tag>)paletteEntry.getValue(), "Properties", CompoundTag.class);
                    for (Property<?> property : blockState.getStates().keySet()) {
                        if (!properties.containsKey(property.getName())) continue;
                        String value = properties.getString(property.getName());
                        try {
                            blockState = this.getBlockStateWith(blockState, property, value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidFormatException("Invalid block state for " + blockState.getBlockType().getId() + ", " + property.getName() + ": " + value);
                        }
                    }
                }
                palette[paletteEntryId] = blockState;
            }
            if (paletteSize == 1) {
                this.blocks.put(y, (Object)palette);
                continue;
            }
            long[] blockStatesSerialized = NBTUtils.getChildTag((Map<String, Tag>)blockStatesTag.getValue(), "data", LongArrayTag.class).getValue();
            BlockState[] chunkSectionBlocks = new BlockState[4096];
            this.blocks.put(y, (Object)chunkSectionBlocks);
            this.readBlockStates(palette, blockStatesSerialized, chunkSectionBlocks);
        }
    }

    protected void readBlockStates(BlockState[] palette, long[] blockStatesSerialized, BlockState[] chunkSectionBlocks) throws InvalidFormatException {
        PackedIntArrayReader reader = new PackedIntArrayReader(blockStatesSerialized);
        for (int blockPos = 0; blockPos < chunkSectionBlocks.length; ++blockPos) {
            int index = reader.get(blockPos);
            if (index >= palette.length) {
                throw new InvalidFormatException("Invalid block state table entry: " + index);
            }
            chunkSectionBlocks[blockPos] = palette[index];
        }
    }

    private <T> BlockState getBlockStateWith(BlockState source, Property<T> property, String value) {
        return source.with(property, property.getValueFor(value));
    }

    private void populateTileEntities() throws DataException {
        this.tileEntities = new HashMap<BlockVector3, Map<String, Tag>>();
        if (!this.rootTag.getValue().containsKey("block_entities")) {
            return;
        }
        Object tags = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "block_entities", ListTag.class).getValue();
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (!(tag instanceof CompoundTag)) {
                throw new InvalidFormatException("CompoundTag expected in block_entities");
            }
            CompoundTag t = (CompoundTag)tag;
            HashMap values = new HashMap(t.getValue());
            int x = ((IntTag)values.get("x")).getValue();
            int y = ((IntTag)values.get("y")).getValue();
            int z = ((IntTag)values.get("z")).getValue();
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, values);
        }
    }

    @Nullable
    private CompoundTag getBlockTileEntity(BlockVector3 position) throws DataException {
        Map<String, Tag> values;
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        if ((values = this.tileEntities.get(position)) == null) {
            return null;
        }
        return new CompoundTag(values);
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int section = y >> 4;
        int yIndex = y & 0xF;
        BlockState[] sectionBlocks = (BlockState[])this.blocks.get(section);
        if (sectionBlocks == null) {
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        BlockState state = sectionBlocks[sectionBlocks.length == 1 ? 0 : yIndex << 8 | z << 4 | x];
        CompoundTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }
}

